/* $Id: brcups_commands.h,v 1.11 2005/08/22 02:20:49 cvs Exp $ */
//* Brother CUPS wrapper tool
//* Copyright (C) 2005-2014 Brother. Industries, Ltd.//*
//*                                    Ver1.00
//*
//* This program is free software; you can redistribute it and/or modify it
//* under the terms of the GNU General Public License as published by the Free
//* Software Foundation; either version 2 of the License, or (at your option)
//* any later version.
//*
//* This program is distributed in the hope that it will be useful, but WITHOUT
//* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
//* more details.
//*
//* You should have received a copy of the GNU General Public License along with
//* this program; if not, write to the Free Software Foundation, Inc., 59 Temple
//* Place, Suite 330, Boston, MA  02111-1307  USA
//*

#ifndef _BRCUPS_COMMANDS_H_
#define _BRCUPS_COMMANDS_H_


char brprintconf[30] = "brprintconf";
/*
//   +++++++++++++++++++++++++++
//       set default
//   +++++++++++++++++++++++++++

char *default_setting[] = {
    // Collate
    "brprintconf -P BROTHERPRINTER_XXX  -collate OFF",
    // copies
    "brprintconf -P BROTHERPRINTER_XXX  -copy 1",
    // Chain
    "brprintconf -P BROTHERPRINTER_XXX  -md Plain",
    // Bringhtness
    "brprintconf -P BROTHERPRINTER_XXX  -brit 0",
    // Contrast
    "brprintconf -P BROTHERPRINTER_XXX  -cont 0",
    // Halftone
    "brprintconf -P BROTHERPRINTER_XXX  -half ErrorDiffusion",
    // Auto cut
    "brprintconf -P BROTHERPRINTER_XXX  -hcut ON",
    // Auto cut
    "brprintconf -P BROTHERPRINTER_XXX  -cut OFF",
    // Mirror
    "brprintconf -P BROTHERPRINTER_XXX  -mirro OFF",
    // Resolution
    "brprintconf -P BROTHERPRINTER_XXX  -reso Normal",
    // Margin(Feed)
    "brprintconf -P BROTHERPRINTER_XXX  -margin 1",
    // Media
    "brprintconf -P BROTHERPRINTER_XXX  -media brS12mm",
     NULL
};

*/
typedef struct {
    char *option;
    char *value;
} CMDLINELIST;
//   +++++++++++++++++++++++++++

//       command line   (Brother command)
//   +++++++++++++++++++++++++++

CMDLINELIST commandlinelist[] = {
    // Collate
    { "BRCollate=OFF"           ,   "-collate OFF"      },
    { "BRCollate=ON"            ,   "-collate ON"       },
    
    // Media    
    { "BRMediaType=Plain"       ,   "-md Plain"         },
    { "BRMediaType=Thin"        ,   "-md Thin"          },
    { "BRMediaType=Thick"       ,   "-md Thick"         },
    { "BRMediaType=Thicker"     ,   "-md Thicker"       },
    { "BRMediaType=BOND"        ,   "-md BOND"          },
    { "BRMediaType=Recycled"    ,   "-md Recycled"      },
    { "BRMediaType=Env"         ,   "-md Env"           },
    { "BRMediaType=EnvThin"     ,   "-md EnvThin"       },
    { "BRMediaType=EnvThick"    ,   "-md EnvThick"      },
    { "BRMediaType=PostCard"    ,   "-md PostCard"      },
    { "BRMediaType=Label"       ,   "-md Label"         },
    { "BRMediaType=Glossy"      ,   "-md Glossy"        },

    // RResolution
    { "BRResolution=600dpi"     ,   "-reso Normal"      },
    { "BRResolution=600x2400dpi",   "-reso Fine"        },

    //InputSlot
    { "BRInputSlot=AutoSelect"  ,   "-inslot AutoSelect"},
    { "BRInputSlot=Tray1"       ,   "-inslot Tray1"     },
    { "BRInputSlot=Manual"      ,   "-inslot Manual"    },
    { "BRInputSlot=Tray2"       ,   "-inslot Tray2"     },
    { "BRInputSlot=MPTray"      ,   "-inslot MPTray"    },

    //BRMonoColor
    { "BRMonoColor=Auto"        ,   "-corm Auto"        },
    { "BRMonoColor=FullColor"   ,   "-corm FullColor"   },
    { "BRMonoColor=Mono"        ,   "-corm Mono"        },

    // For OpenOffice
    { "PageSize=A4"             ,   "-pt A4"            },
    { "PageSize=Letter"         ,   "-pt Letter"        },
    { "PageSize=Legal"          ,   "-pt Legal"         },
    { "PageSize=Executive"      ,   "-pt Executive"     },
    { "PageSize=A5"             ,   "-pt A5"            },
    { "PageSize=A6"             ,   "-pt A6"            },
    { "PageSize=ISOB5"          ,   "-pt ISOB5"         },
    { "PageSize=B5"             ,   "-pt JISB5"         },
    { "PageSize=JISB6"          ,   "-pt JISB6"         },
    { "PageSize=EnvDL"          ,   "-pt EnvDL"         },
    { "PageSize=EnvC5"          ,   "-pt EnvC5"         },
    { "PageSize=Env10"          ,   "-pt Env10"         },
    { "PageSize=EnvMonarch"     ,   "-pt EnvMonarch"    },
    { "PageSize=Br3x5"          ,   "-pt Br3x5"         },
    { "PageSize=FanFoldGermanLegal", "-pt FanFoldGermanLegal" },
    { "PageSize=Postcard"       ,   "-pt Postcard"      },
    { "PageSize=EnvYou4"        ,   "-pt EnvYou4"       },
    { "PageSize=EnvChou3"       ,   "-pt EnvChou3"      },
    { "PageSize=210x270mm"      ,   "-pt 210x270mm"     },
    { "PageSize=195x270mm"      ,   "-pt 195x270mm"     },
    { "PageSize=184x260mm"      ,   "-pt 184x260mm"     },
    { "PageSize=197x273mm"      ,   "-pt 197x273mm"     },

    // Gray
    { "BRGray=OFF"              ,   "-gray OFF"         },
    { "BRGray=ON"               ,   "-gray ON"          },

    // ColorMatch
    { "BRColorMatching=Normal"  ,   "-cm Normal"        },
    { "BRColorMatching=Vivid"   ,   "-cm Vivid"         },
    { "BRColorMatching=None"    ,   "-cm None"          },

    // ToneSave
    { "BRTonerSaveMode=OFF"     ,   "-ts OFF"           },
    { "BRTonerSaveMode=ON"      ,   "-ts ON"            },

    // BRImproveOutput
    { "BRImproveOutput=OFF"     ,   "-improve OFF"      },
    { "BRImproveOutput=BRLessPaperCurl" , "-improve BRLessPaperCurl" },
    { "BRImproveOutput=BRFixIntensity"  , "-improve BRFixIntensity"  },

    // BREnhanceBlkPrt
    { "BREnhanceBlkPrt=OFF"     , "-bp OFF"             },
    { "BREnhanceBlkPrt=ON"      , "-bp ON"              },

    //BRReversePrint
    { "BRReverse=ON"            ,   "-rev ON"           },
    { "BRReverse=OFF"           ,   "-rev OFF"          },

    // Duplex
    { "BRDuplex=None"           ,   "-duplex None"      },
    { "BRDuplex=DuplexTumble"   ,   "-duplex DuplexTumble"  },
    { "BRDuplex=DuplexNoTumble" ,   "-duplex DuplexNoTumble"},

    // Skip Blank Page
    { "BRSkipBlank=OFF"         ,   "-sb OFF"           },
    { "BRSkipBlank=ON"          ,   "-sb ON"            },

    { NULL   ,   NULL    },
};

//   +++++++++++++++++++++++++++
//       command line   (Standard command)
//   +++++++++++++++++++++++++++
CMDLINELIST standard_commandlinelist[] = {
    // for Fedora OpenOffice
    { NULL  ,   NULL    },
};

//   +++++++++++++++++++++++++++
//       command line numerical value
//   +++++++++++++++++++++++++++
CMDLINELIST commandlinelist2[] = {

    { "BRBrightness="   ,   "-brit "    },
    { "BRContrast="     ,   "-cont "    },
    { "BRRed="          ,   "-red "     },
    { "BRGreen="        ,   "-green "   },
    { "BRBlue="         ,   "-blue "    },
    { "BRSaturation="   ,   "-satu "    },
    { NULL  ,   NULL    },
};

/*      PPD Default   */
//   +++++++++++++++++++++++++++
//       PPD setting list
//   +++++++++++++++++++++++++++
typedef struct {
    char *value;
    char *brcommand;
} PPDCOMMANDLIST;

typedef struct {
   char             *label;
   PPDCOMMANDLIST   ppdcommandlist[];
} PPDCOMMAND;

//       ***** DefaultResolution *****
PPDCOMMAND DefaultBRResolution = {
    "DefaultBRResolution",
    {
        { "600dpi"      ,   "-reso Normal"  },
        { "600x2400dpi" ,   "-reso Fine"    },
        { NULL , NULL  }
    }
};

//       ***** DefaultPageSize *****
PPDCOMMAND DefaultPageSize = {
    "DefaultPageSize",
    {
        { "A4"                  ,   "-pt A4"                },
        { "Letter"              ,   "-pt Letter"            },
        { "Legal"               ,   "-pt Legal"             },
        { "Executive"           ,   "-pt Executive"         },
        { "A5"                  ,   "-pt A5"                },
        { "A6"                  ,   "-pt A6"                },
        { "ISOB5"               ,   "-pt ISOB5"             },
        { "B5"                  ,   "-pt JISB5"             },
        { "JISB6"               ,   "-pt JISB6"             },
        { "EnvDL"               ,   "-pt EnvDL"             },
        { "EnvC5"               ,   "-pt EnvC5"             },
        { "Env10"               ,   "-pt Env10"             },
        { "EnvMonarch"          ,   "-pt EnvMonarch"        },
        { "Br3x5"               ,   "-pt Br3x5"             },
        { "FanFoldGermanLegal"  ,   "-pt FanFoldGermanLegal"},
        { "Postcard"            ,   "-pt Postcard"          },
        { "EnvYou4"             ,   "-pt EnvYou4"           },
        { "EnvChou3"            ,   "-pt EnvChou3"          },
        { "210x270mm"           ,   "-pt 210x270mm"         },
        { "195x270mm"           ,   "-pt 195x270mm"         },
        { "184x260mm"           ,   "-pt 184x260mm"         },
        { "197x273mm"           ,   "-pt 197x273mm"         },
        { NULL , NULL  }
    }
};

//       ***** DefaultBRMonoColor*****
PPDCOMMAND DefaultBRMonoColor = {
    "DefaultBRMonoColor",
    {
        { "Auto"        ,   "-corm Auto"        },
        { "FullColor"   ,   "-corm FullColor"   },
        { "Mono"        ,   "-corm Mono"        },
        { NULL , NULL  }
     }
};

//       ***** DefaultBRGray*****
PPDCOMMAND DefaultBRGray = {
    "DefaultBRGray",
    {
        { "OFF"     ,   "-gray OFF" },
        { "ON"      ,   "-gray ON"  },
        { NULL , NULL  }
    }
};

//       ***** DefaultBRColorMediaType*****
PPDCOMMAND DefaultBRMediaType = {
    "DefaultBRMediaType",
    {
        { "Plain"       ,   "-md Plain"     },
        { "Thin"        ,   "-md Thin"      },
        { "Thick"       ,   "-md Thick"     },
        { "Thicker"     ,   "-md Thicker"   },
        { "BOND"        ,   "-md BOND"      },
        { "Recycled"    ,   "-md Recycled"  },
        { "Env"         ,   "-md Env"       },
        { "EnvThin"     ,   "-md EnvThin"   },
        { "EnvThick"    ,   "-md EnvThick"  },
        { "PostCard"    ,   "-md PostCard"  },
        { "Label"       ,   "-md Label"     },
        { "Glossy"      ,   "-md Glossy"    },
        { NULL , NULL  }
    }
};

//    ******DefaultBRColorMatching**********
PPDCOMMAND  DefaultBRColorMatching = {
    "DefaultBRColorMatching",
    {
        { "Normal"  ,   "-cm Normal"},
        { "Vivid"   ,   "-cm Vivid" },
        { "None"    ,   "-cm None"  },
        { NULL , NULL  }
    }
};

//    ******DefaultTonerSaveMode**********
PPDCOMMAND DefaultBRTonerSaveMode = {
    "DefaultBRTonerSaveMode",
    {
        { "OFF" ,   "-ts OFF"   },
        { "ON"  ,   "-ts ON"    },
        { NULL , NULL  }
    }
};

//    ******DefaultBRImproveOutput**********
PPDCOMMAND DefaultBRImproveOutput = {
    "DefaultBRImproveOutput",
    {
        { "OFF"             ,   "-improve OFF"              },
        { "BRLessPaperCurl" ,   "-improve BRLessPaperCurl"  },
        { "BRFixIntensity"  ,   "-improve BRFixIntensity"   },
        { NULL , NULL  }
    }
};

//    ******DefaultBRColorEnhancement**********
PPDCOMMAND DefaultBRColorEnhancement = {
    "DefaultBREnhanceBlkPrt",
    {
        { "OFF"     ,   "-bp OFF"   },
        { "ON"      ,   "-bp ON"    },
        { NULL , NULL  }
    }
};

//    ******DefaultBRInputSlot**********
PPDCOMMAND DefaultBRInputSlot = {
    "DefaultBRInputSlot",
    {
        { "AutoSelect"  ,   "-inslot AutoSelect"},
        { "Tray1"       ,   "-inslot Tray1"     },
        { "Tray2"       ,   "-inslot Tray2"     },
        { "MPTray"      ,   "-inslot MPTray"    },
        { "Manual"      ,   "-inslot Manual"    },
        { NULL , NULL  }
    }
};

//    ******DefaultBRReversePrint**********
PPDCOMMAND DefaultBRReverse = {
    "DefaultBRReverse",
    {
        { "OFF"     ,   "-rev OFF"  },
        { "ON"      ,   "-rev ON"   },
        { NULL , NULL  }
    }
};

//    ******DefaultBRDuplex**********
PPDCOMMAND DefaultBRDuplex = {
    "DefaultBRDuplex",
    {
        { "None"            ,   "-duplex None"          },
        { "DuplexTumble"    ,   "-duplex DuplexTumble"  },
        { "DuplexNoTumble"  ,   "-duplex DuplexNoTumble"},
        { NULL  , NULL }
    }
};    

PPDCOMMAND DefaultBRSkipBlank = {
    "DefaultBRSkipBlank",
    {
        { "ON"  ,   "-sb ON"    },
        { "OFF" ,   "-sb OFF"   },
        { NULL  ,   NULL }
    }
};   

PPDCOMMAND *ppdcommand_all_list[] = {
    &DefaultBRInputSlot,
    &DefaultBRResolution,
    &DefaultPageSize,
    &DefaultBRMonoColor,
    &DefaultBRGray,
    &DefaultBRMediaType,
    &DefaultBRColorMatching,
    &DefaultBRTonerSaveMode,
    &DefaultBRImproveOutput,
    &DefaultBRColorEnhancement,
    &DefaultBRReverse,
    &DefaultBRDuplex,
    &DefaultBRSkipBlank,
    NULL
};
/* PPD Default end*/

//   +++++++++++++++++++++++++++
//       PPD numerical value
//   +++++++++++++++++++++++++++

CMDLINELIST PPDdefaultN[] = {
    { "DefaultBRBrightness" ,   "-brit " },
    { "DefaultBRContrast"   ,   "-cont " },
    { "DefaultBRRed"        ,   "-red "  },
    { "DefaultBRGreen"      ,   "-green "},
    { "DefaultBRBlue"       ,   "-blue " },
    { "DefaultBRSaturation" ,   "-satu " },
    { NULL   ,   NULL    },
};

//   +++++++++++++++++++++++++++
//       command line   (Standard command)
//   +++++++++++++++++++++++++++
CMDLINELIST standard_media_commandlinelist[] = {
    { NULL  , NULL }
};

#endif  //_BRCUPS_COMMANDS_H_
